/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.datagen;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.utils.CardImageUtils;
import dev.lucaargolo.charta.utils.SuitImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_7403;
import org.jetbrains.annotations.NotNull;

public class SuitImageProvider
implements class_2405 {
    private final FabricDataOutput output;

    public SuitImageProvider(FabricDataOutput output) {
        this.output = output;
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 cachedOutput) {
        return CompletableFuture.runAsync(() -> {
            Path outputPath = this.output.method_45971();
            String cardsOutputPath = String.valueOf(outputPath) + File.separator + "data" + File.separator + "charta" + File.separator + "images" + File.separator + "suit";
            try {
                URL resource = Charta.class.getClassLoader().getResource("suits");
                URI uri = Objects.requireNonNull(resource).toURI();
                try (Stream<Path> paths = Files.walk(Paths.get(uri), new FileVisitOption[0]);){
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        String fileName = path.getFileName().toString();
                        String suitName = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName;
                        String parentFolder = path.getParent().toString();
                        String subFolder = parentFolder.substring(parentFolder.indexOf("suits") + "suits".length());
                        File cardOutputFolder = new File(cardsOutputPath + File.separator + subFolder + File.separator + suitName);
                        cardOutputFolder.mkdirs();
                        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                            SuitImage.saveSuits(ImageIO.read(stream), cardOutputFolder, (fileToSave, suitImage) -> CardImageUtils.saveImage(suitImage, fileToSave, cachedOutput));
                        }
                        catch (Exception e) {
                            Charta.LOGGER.error("Error loading image: {}", path, (Object)e);
                        }
                    });
                }
            }
            catch (IOException | URISyntaxException e) {
                Charta.LOGGER.error("Error loading suits", (Throwable)e);
            }
        });
    }

    @NotNull
    public String method_10321() {
        return "Suits";
    }
}

